function Balatrostuck.INIT.Jokers.j_whitequeen()
    SMODS.Joker{
        name = "White Queen",
        key = "whitequeen",
        config = {
            extra = {
            }
        },
        loc_txt = {
            ['name'] = 'White Queen',
            ['text'] = {
                'Played {C:attention}Queens{} of {C:diamonds}Diamonds',
                'gain a {C:money}Gold Seal{}'
            },
            unlock = {'Unlocked by',
                    'finishing Act 1'}
        },
        pos = {
            x = 5,
            y = 12
         },
        cost = 3,
        rarity = 1,
        blueprint_compat = true,
        eternal_compat = false,
        unlocked = false,
        atlas = 'HomestuckJokers',
        calculate = function(self,card,context)
            if context.individual and context.cardarea == G.play then
                if context.other_card:get_id() == 12 and context.other_card:is_suit('Diamonds') and
                context.other_card:get_seal(true) ~= 'Gold' then
                    local cunningham = context.other_card
                    G.E_MANAGER:add_event(Event({
                        func = function() 
                            cunningham:set_seal('Gold', nil, true)
                            return true 
                        end
                    }))
                    return {
                        dollars = 3,
                        card = context.other_card
                    }
                end
            end
        end,
        check_for_unlock = function(self,args)
            if args.type == 'bstuck_apple_eaten' then
                unlock_card(self)
            end
        end,
        loc_vars = function(self, info_queue, card) 
            info_queue[#info_queue + 1] = {key = 'gold_seal', set = 'Other'}
            art_credit('akai', info_queue)
        end,
    }
end