function Balatrostuck.INIT.Jokers.j_courtyarddroll()
    SMODS.Joker{
        name = "Courtyard Droll",
        key = "courtyarddroll",
        config = {
            extra = {
            }
        },
        loc_txt = {
            ['name'] = 'Courtyard Droll',
            ['text'] = {
                'If played hand contains a {C:attention}Flush{}',
                'and a scoring {C:clubs}Clubs{} card, all',
                '{C:attention}played cards{} become {C:attention}Stone{} cards',
                'and this Joker {C:red,E:2}self destructs{}'
            }
        },
        pos = {
            x = 5,
            y = 5
        },
        cost = 4,
        rarity = 1,
        blueprint_compat = true,
        eternal_compat = true,
        unlocked = true,
        atlas = 'HomestuckJokers',
        calculate = function(self,card,context)
            if context.cardarea == G.jokers and context.before and (next(context.poker_hands["Flush"]) or next(context.poker_hands["Flush Five"]) or next(context.poker_hands["Flush House"]) or next(context.poker_hands["Straight Flush"])) then
                local has_clubs = false
                for _, v in ipairs(context.scoring_hand) do
                    if v:is_suit("Clubs") then has_clubs = true end
                end
    
                if has_clubs then
                    for _, v in ipairs(context.full_hand) do
                        v:set_ability(G.P_CENTERS.m_stone, nil, true)
                        G.E_MANAGER:add_event(Event({
                            func = function()
                                v:juice_up()
                                return true
                            end
                        })) 
                    end
                    G.E_MANAGER:add_event(Event({
                        func = function()
                            play_sound('tarot1')
                            card.T.r = -0.2
                            card:juice_up(0.3, 0.4)
                            card.states.drag.is = true
                            card.children.center.pinch.x = true
                            G.E_MANAGER:add_event(Event({trigger = 'after', delay = 0.3, blockable = false,
                                func = function()
                                        G.jokers:remove_card(self)
                                        card:remove()
                                        card = nil
                                    return true; end})) 
                            return true
                        end
                    }))
                    return {
                        card = card,
                        message = 'Oops!'
                    }
                end
            end
        end,
        loc_vars = function (self, info_queue, card)
            art_credit('akai', info_queue)
            info_queue[#info_queue + 1] = G.P_CENTERS['m_stone']
        end
    }
end